﻿/*
	VERSION:		1.1
	
	USAGE:
		#include "autoSort.as"
		addAutoSort( spriteLayer_mc );
*/
addAutoSort = function( spriteLayer_mc )
{
	// create container
	var _this = new Object();
	
	// Store settings
	_this.spriteLayer_mc = spriteLayer_mc;		// movieClip contaiing all the sprites that will be sorted
	_this.parallelSprites = 10;							// number of sprites allowed side-by-side, at the same _y
	
	// Sort the sprites
	_this.loop = function()
	{
		for (var nam in spriteLayer_mc)
		{
			var thisSprite = _this.spriteLayer_mc[nam];
			var currentDepth = thisSprite.getDepth();
			var newDepth =  thisSprite._y * _this.parallelSprites;
			var existingSprite = _this.spriteLayer_mc.getInstanceAtDepth(newDepth);
			while (existingSprite != undefined  &&  existingSprite != thisSprite)
			{	// if something exists at the intended depth, and it isn't thisSprite
				newDepth++;
				existingSprite = _this.spriteLayer_mc.getInstanceAtDepth(newDepth);
			}// while:  a movieClip exists at this location
			thisSprite.swapDepths(newDepth);
		}// for...in:   spriteLayer_mc
	}// loop()
	_this.loopInterval = setInterval( _this.loop, 1000/30 );		// 30 FPS
	
	// return this object
	return _this;
}// addAutoSort()
